"use strict";
exports.id = 763;
exports.ids = [763];
exports.modules = {

/***/ 5763:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Layout)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(968);
var head_default = /*#__PURE__*/__webpack_require__.n(head_);
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
var link_default = /*#__PURE__*/__webpack_require__.n(next_link);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(1853);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
;// CONCATENATED MODULE: ./components/layout/navbar.js




const Navbar = (props)=>{
    const router = (0,router_.useRouter)();
    (0,external_react_.useEffect)(()=>{
        const select = (el, all = false)=>{
            try {
                el = el.trim();
                if (all) {
                    return [
                        ...document.querySelectorAll(el)
                    ];
                } else {
                    return document.querySelector(el);
                }
            } catch (error) {}
        };
        const on = (type, el, listener, all = false)=>{
            let selectEl = select(el, all);
            if (selectEl) {
                if (all) {
                    selectEl.forEach((e)=>e.addEventListener(type, listener));
                } else {
                    selectEl.addEventListener(type, listener);
                }
            }
        };
        const scrollValue = ()=>{
            const scroll = window.scrollY;
            const navbar = document.getElementById("header");
            if (scroll > 100) {
                navbar.classList.add("header-scrolled");
            } else {
                navbar.classList.remove("header-scrolled");
            }
        };
        window.addEventListener("scroll", scrollValue);
        const onscroll = (el, listener)=>{
            el.addEventListener("scroll", listener);
        };
        let backtotop = document.getElementById("back-to-top");
        if (backtotop) {
            const toggleBacktotop = ()=>{
                if (window.scrollY > 100) {
                    backtotop.classList.add("active");
                } else {
                    backtotop.classList.remove("active");
                }
            };
            window.addEventListener("load", toggleBacktotop);
            onscroll(document, toggleBacktotop);
        }
        const el_toggle = document.querySelector(".mobile-nav-toggle");
        el_toggle.addEventListener("click", (e)=>{
            document.getElementById("navbar").classList.toggle("navbar-mobile");
            el_toggle.classList.toggle("bi-list");
            el_toggle.classList.toggle("bi-x");
        });
        on("click", ".navbar .dropdown > a", function(e) {
            if (select("#navbar").classList.contains("navbar-mobile")) {
                e.preventDefault();
                this.nextElementSibling.classList.toggle("dropdown-active");
            }
        }, true);
        let lastScrollTop = 0;
        const floatingMobile = ()=>{
            const floatingMobile = document.getElementById("floating-mobile");
            if (!floatingMobile) return;
            const st = window.pageYOffset || document.documentElement.scrollTop;
            if (st > lastScrollTop) {
                floatingMobile.classList.add("d-none");
                floatingMobile.classList.remove("d-block");
                floatingMobile.classList.remove("animate-fade-up");
            } else {
                floatingMobile.classList.add("d-block");
                floatingMobile.classList.add("animate-fade-up");
                floatingMobile.classList.remove("d-none");
            }
            lastScrollTop = st <= 0 ? 0 : st;
            // if floating mobile until the bottom of the page
            if (window.innerHeight + window.scrollY >= document.body.offsetHeight) {
                floatingMobile.classList.add("d-block");
                floatingMobile.classList.add("animate-fade-up");
                floatingMobile.classList.remove("d-none");
            }
        };
        document.addEventListener("scroll", floatingMobile);
    }, []);
    return /*#__PURE__*/ jsx_runtime_.jsx("header", {
        id: "header",
        className: "fixed-top d-flex align-items-center " + props.background,
        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
            className: "container d-flex align-items-center justify-content-between",
            children: [
                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    className: "logo",
                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                        href: "/",
                        children: /*#__PURE__*/ jsx_runtime_.jsx("h1", {
                            className: "text-white",
                            children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                children: "MuraPay"
                            })
                        })
                    })
                }),
                /*#__PURE__*/ (0,jsx_runtime_.jsxs)("nav", {
                    id: "navbar",
                    className: "navbar",
                    children: [
                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("ul", {
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: "/",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: router.pathname == "/" ? "nav-link scrollto active" : "nav-link scrollto",
                                            children: "Home"
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: "/kemitraan",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: router.pathname == "/kemitraan" ? "nav-link scrollto active" : "nav-link scrollto",
                                            children: "Kemitraan"
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: "/partnership",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: router.pathname == "/partnership" ? "nav-link scrollto active" : "nav-link scrollto",
                                            children: "Partnership Dealer"
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: "/harga",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: router.pathname == "/harga" ? "nav-link scrollto active" : "nav-link scrollto",
                                            children: "Harga"
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: "/about",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: router.pathname == "/about" ? "nav-link scrollto active" : "nav-link scrollto",
                                            children: "Tentang Kami"
                                        })
                                    })
                                })
                            ]
                        }),
                        /*#__PURE__*/ jsx_runtime_.jsx("i", {
                            className: "bi bi-list mobile-nav-toggle"
                        })
                    ]
                })
            ]
        })
    });
};
/* harmony default export */ const navbar = (Navbar);

;// CONCATENATED MODULE: ./public/img/favicon.png
/* harmony default export */ const favicon = ({"src":"/_next/static/media/favicon.111d148b.png","height":32,"width":32,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAABB0lEQVR42mOQ1/RRNTAPOcUq5vKfgcHuH7es+z8GZof/+mbBp5R1fFUZgJKnQZKxyaV/eybP+9/ZNfV/fnHjXwagGEgRA0gyOrns75IFy/83pef+nzZ3xf/5C1f9L6to+8vAYP+fgYHB9l/vlAX/p6cm/l9uxvD/xLFT/6vru//3TZj1X0bd5x8Dg4DTv0nTF/1fEu7yf0d+2P8dazf8r27q/9/XP+u/kKLHPwaQMSVA41av3/H/1LGT/yuq2//XAxUUlzZDrNA2Djwtruz5f9KUeX+1rSL+MzAY/Xdyj/8rqer1X8ck6BSDhmGAqi6QAZLQMvD/Z2IV9k9Ry/e/rmnQKTV9f1UAtpx7zOAv5c8AAAAASUVORK5CYII=","blurWidth":8,"blurHeight":8});
// EXTERNAL MODULE: ./node_modules/next/image.js
var next_image = __webpack_require__(5675);
var image_default = /*#__PURE__*/__webpack_require__.n(next_image);
;// CONCATENATED MODULE: ./components/layout/footer.js





const Footer = ()=>{
    const router = (0,router_.useRouter)();
    const scrolltop = ()=>{
        window.scrollTo({
            top: 0,
            behavior: "smooth"
        });
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("footer", {
        id: "footer",
        className: "bg-blue-6",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "footer-top",
                children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    className: "container",
                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                        className: "row",
                        children: [
                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                className: "col-lg-5 col-md-6 mb-3",
                                children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                    className: "",
                                    children: [
                                        /*#__PURE__*/ jsx_runtime_.jsx("h3", {
                                            children: "MuraPay"
                                        }),
                                        /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                            className: "pb-3 my-0",
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("em", {
                                                children: "Bangun usahamu sampai ke level tertinggi dengan harga terbaik, produk digital ter-update, dan pelayanan solutif."
                                            })
                                        }),
                                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("p", {
                                            children: [
                                                "Jl. Batan Selatan No.54, Miroto, Kec. Semarang Tengah, ",
                                                /*#__PURE__*/ jsx_runtime_.jsx("br", {}),
                                                " Kota Semarang, Jawa Tengah 50134"
                                            ]
                                        }),
                                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                            className: "social-links mt-3",
                                            children: [
                                                /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                    href: "https://www.instagram.com/murapay.id/",
                                                    target: "_blank",
                                                    rel: "noreferrer",
                                                    className: "instagram bg-orange me-2",
                                                    children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                                        xmlns: "http://www.w3.org/2000/svg",
                                                        width: 16,
                                                        height: 16,
                                                        fill: "currentColor",
                                                        className: "bi bi-instagram",
                                                        viewBox: "0 0 16 16",
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                                            d: "M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.917 3.917 0 0 0-1.417.923A3.927 3.927 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.916 3.916 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.926 3.926 0 0 0-.923-1.417A3.911 3.911 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0h.003zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599.28.28.453.546.598.92.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.47 2.47 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.478 2.478 0 0 1-.92-.598 2.48 2.48 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233 0-2.136.008-2.388.046-3.231.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92.28-.28.546-.453.92-.598.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045v.002zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92zm-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217zm0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334z"
                                                        })
                                                    })
                                                }),
                                                /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                    href: " https://www.youtube.com/channel/UCSdb72vsk2HVIKnBQNM0vBg",
                                                    target: "_blank",
                                                    className: "instagram bg-orange",
                                                    children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                                        xmlns: "http://www.w3.org/2000/svg",
                                                        width: 16,
                                                        height: 16,
                                                        fill: "currentColor",
                                                        className: "bi bi-youtube",
                                                        viewBox: "0 0 16 16",
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                                            d: "M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.007 2.007 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.007 2.007 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31.4 31.4 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.007 2.007 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A99.788 99.788 0 0 1 7.858 2h.193zM6.4 5.209v4.818l4.157-2.408L6.4 5.209z"
                                                        })
                                                    })
                                                })
                                            ]
                                        })
                                    ]
                                })
                            }),
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                className: "col-lg-3 offset-lg-1 col-md-6 footer-links",
                                children: [
                                    /*#__PURE__*/ jsx_runtime_.jsx("h4", {
                                        children: "Navigasi"
                                    }),
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("ul", {
                                        children: [
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("li", {
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("i", {
                                                        className: "bx bx-chevron-right"
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                                        href: "/",
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                            children: "Home"
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("li", {
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("i", {
                                                        className: "bx bx-chevron-right"
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                                        href: "/kemitraan",
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                            children: "Kemitraan"
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("li", {
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("i", {
                                                        className: "bx bx-chevron-right"
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                                        href: "/partnership",
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                            children: "Partnership"
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("li", {
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("i", {
                                                        className: "bx bx-chevron-right"
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                                        href: "/harga",
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                            children: "Harga"
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("li", {
                                                children: [
                                                    /*#__PURE__*/ jsx_runtime_.jsx("i", {
                                                        className: "bx bx-chevron-right"
                                                    }),
                                                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                                        href: "/about",
                                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                            children: "Tentang Kami"
                                                        })
                                                    })
                                                ]
                                            })
                                        ]
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                className: "col-lg-3 col-md-6 footer-newsletter",
                                children: [
                                    /*#__PURE__*/ jsx_runtime_.jsx("h4", {
                                        children: "Hubungi Kami"
                                    }),
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("a", {
                                        className: "text-white",
                                        style: {
                                            cursor: "pointer"
                                        },
                                        href: "https://api.whatsapp.com/send/?phone=6281329701020&text&type=phone_number&app_absent=0",
                                        target: "_blank",
                                        rel: "noreferrer",
                                        children: [
                                            /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                                xmlns: "http://www.w3.org/2000/svg",
                                                width: 20,
                                                height: 20,
                                                fill: "currentColor",
                                                className: "bi bi-whatsapp me-2",
                                                viewBox: "0 0 16 16",
                                                children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                                    d: "M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"
                                                })
                                            }),
                                            "+6281 329 70 10 20"
                                        ]
                                    }),
                                    /*#__PURE__*/ jsx_runtime_.jsx("br", {}),
                                    /*#__PURE__*/ jsx_runtime_.jsx("br", {}),
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("a", {
                                        href: "mailto:info@murapay.id",
                                        className: "text-white",
                                        target: "_blank",
                                        rel: "noreferrer",
                                        style: {
                                            cursor: "pointer"
                                        },
                                        children: [
                                            /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                                xmlns: "http://www.w3.org/2000/svg",
                                                width: 20,
                                                height: 20,
                                                fill: "currentColor",
                                                className: "bi bi-envelope me-2",
                                                viewBox: "0 0 16 16",
                                                children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                                    d: "M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z"
                                                })
                                            }),
                                            "info@murapay.id"
                                        ]
                                    })
                                ]
                            })
                        ]
                    })
                })
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "container",
                children: [
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                        className: "copyright",
                        children: [
                            "\xa9 Copyright",
                            " ",
                            /*#__PURE__*/ jsx_runtime_.jsx("strong", {
                                children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    children: "MuraPay"
                                })
                            }),
                            ". All Rights Reserved"
                        ]
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "credits"
                    })
                ]
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "d-none d-md-block",
                        children: router.pathname === "/partnership" ? /*#__PURE__*/ jsx_runtime_.jsx("a", {
                            href: "https://api.whatsapp.com/send/?phone=6281329701020&text=Hallo,saya ingin bertanya mengenai program partnership dealer Murapay&type=phone_number&app_absent=0",
                            target: "_blank",
                            rel: "noreferrer",
                            style: {
                                width: "60px",
                                height: "60px"
                            },
                            className: "back-to-top d-flex align-items-center justify-content-center bg-success",
                            id: "back-to-top",
                            children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                xmlns: "http://www.w3.org/2000/svg",
                                width: 30,
                                height: 30,
                                fill: "currentColor",
                                className: "bi bi-whatsapp text-white",
                                viewBox: "0 0 16 16",
                                children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                    d: "M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"
                                })
                            })
                        }) : router.pathname === "/kemitraan" ? /*#__PURE__*/ jsx_runtime_.jsx("a", {
                            href: "https://api.whatsapp.com/send/?phone=6281329701020&text=Hallo,saya%20ingin%20mengetahui%20lebih%20lanjut%20mengenai%20kemitraan%20murapay%20&type=phone_number&app_absent=0",
                            target: "_blank",
                            rel: "noreferrer",
                            style: {
                                width: "60px",
                                height: "60px"
                            },
                            className: "back-to-top d-flex align-items-center justify-content-center bg-success",
                            id: "back-to-top",
                            children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                xmlns: "http://www.w3.org/2000/svg",
                                width: 30,
                                height: 30,
                                fill: "currentColor",
                                className: "bi bi-whatsapp text-white",
                                viewBox: "0 0 16 16",
                                children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                    d: "M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"
                                })
                            })
                        }) : router.pathname === "/" ? /*#__PURE__*/ jsx_runtime_.jsx("a", {
                            href: "https://api.whatsapp.com/send/?phone=6281329701020&text=Hallo,saya%20ingin%20mengetahui%20lebih%20lanjut%20mengenai%20murapay%20&type=phone_number&app_absent=0",
                            target: "_blank",
                            rel: "noreferrer",
                            style: {
                                width: "60px",
                                height: "60px"
                            },
                            className: "back-to-top d-flex align-items-center justify-content-center bg-success",
                            id: "back-to-top",
                            children: /*#__PURE__*/ jsx_runtime_.jsx("svg", {
                                xmlns: "http://www.w3.org/2000/svg",
                                width: 30,
                                height: 30,
                                fill: "currentColor",
                                className: "bi bi-whatsapp text-white",
                                viewBox: "0 0 16 16",
                                children: /*#__PURE__*/ jsx_runtime_.jsx("path", {
                                    d: "M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"
                                })
                            })
                        }) : /*#__PURE__*/ jsx_runtime_.jsx("a", {
                            onClick: scrolltop,
                            className: "back-to-top d-flex align-items-center justify-content-center",
                            id: "back-to-top",
                            children: /*#__PURE__*/ jsx_runtime_.jsx("i", {
                                className: "bi bi-arrow-up-short"
                            })
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "fixed-bottom d-none d-md-none bg-dark-blue",
                        id: "floating-mobile",
                        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "row d-flex justify-content-center align-items-center py-3",
                            style: {
                                paddingLeft: "20px",
                                paddingRight: "20px"
                            },
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                    className: "col-2",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((image_default()), {
                                        src: favicon,
                                        alt: "icon-footer-1"
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                    className: "col-5",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                        className: "d-flex flex-column align-self-center",
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                            className: "text-white fw-bolder",
                                            style: {
                                                fontSize: "1rem"
                                            },
                                            children: "MuraPay"
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                    className: "col-5",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                        className: "btn bg-orange text-white w-100 h-100",
                                        children: "Download"
                                    })
                                })
                            ]
                        })
                    })
                ]
            })
        ]
    });
};
/* harmony default export */ const footer = (Footer);

;// CONCATENATED MODULE: ./components/layout/layout.js




function Layout(props) {
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        children: [
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)((head_default()), {
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("meta", {
                        name: "viewport",
                        content: "width=device-width, initial-scale=1, shrink-to-fit=no"
                    }),
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("title", {
                        children: [
                            "Murapay | ",
                            props.title
                        ]
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("meta", {
                        content: props.description,
                        name: "description"
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("meta", {
                        content: props.keyword,
                        name: "keywords"
                    })
                ]
            }),
            /*#__PURE__*/ jsx_runtime_.jsx(navbar, {
                background: props.background
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("main", {
                id: "main",
                className: "w-100",
                children: props.children
            }),
            /*#__PURE__*/ jsx_runtime_.jsx(footer, {})
        ]
    });
}


/***/ })

};
;