import * as NProgress from 'nprogress';
import * as PropTypes from 'prop-types';
import * as React from 'react';

/**
 *
 * NProgress
 *
 */

interface NextNProgressProps {
    /**
     * The color of the bar.
     * @default "#29D"
     */
    color?: string;
    /**
     * The start position of the bar.
     * @default 0.3
     */
    startPosition?: number;
    /**
     * The stop delay in milliseconds.
     * @default 200
     */
    stopDelayMs?: number;
    /**
     * The height of the bar.
     * @default 3
     */
    height?: number;
    /**
     * Whether to show the bar on shallow routes.
     * @default true
     */
    showOnShallow?: boolean;
    /**
     * The other NProgress configuration options to pass to NProgress.
     * @default null
     */
    options?: Partial<NProgress.NProgressOptions>;
    /**
     * The nonce attribute to use for the `style` tag.
     * @default undefined
     */
    nonce?: string;
    /**
     * Use your custom CSS tag instead of the default one.
     * This is useful if you want to use a different style or minify the CSS.
     * @default (css) => <style nonce={nonce}>{css}</style>
     */
    transformCSS?: (css: string) => JSX.Element;
}
declare const _default: React.MemoExoticComponent<{
    ({ color, startPosition, stopDelayMs, height, showOnShallow, options, nonce, transformCSS, }: NextNProgressProps): JSX.Element;
    propTypes: {
        color: PropTypes.Requireable<string>;
        startPosition: PropTypes.Requireable<number>;
        stopDelayMs: PropTypes.Requireable<number>;
        height: PropTypes.Requireable<number>;
        showOnShallow: PropTypes.Requireable<boolean>;
        options: PropTypes.Requireable<object>;
        nonce: PropTypes.Requireable<string>;
        transformCSS: PropTypes.Requireable<(...args: any[]) => any>;
    };
}>;

export { NextNProgressProps, _default as default };
